<?php
/**
 * All AJAX related functions
 */
namespace Codexpert\CoDesigner_Pro\App;
use Codexpert\Plugin\Base;
use Elementor\Plugin as Elementor;
use Codexpert\CoDesigner_Pro\Helper;
/**
 * if accessed directly, exit.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * @package Plugin
 * @subpackage AJAX
 * @author Codexpert <hi@codexpert.io>
 */
class AJAX extends Base {

	public $plugin;
	public $slug;
	public $name;
	public $version;

	/**
	 * Constructor function
	 */
	public function __construct( $plugin ) {
		$this->plugin	= $plugin;
		$this->slug		= $this->plugin['TextDomain'];
		$this->name		= $this->plugin['Name'];
		$this->version	= $this->plugin['Version'];
	}

	public function some_callback() {
		
		$response = [
			'status'	=> 0,
			'message'	=> __( 'Unauthorized', 'codesigner-pro' ),
		];

		if( ! wp_verify_nonce( $_POST['_wpnonce'] ) ) {
			wp_send_json( $response );
		}
	}

	public function afp_form_submission() {

		$default_inputs = [ 'action', 'afp_product_id', 'afp_rep_msg', 'afp_resp_redirect', 'afp_mail_subject', 'afp_mail_body', 'afp_admin_mail_subject', 'afp_mail_name' ];

		$table_row = "";
		$target_string = $replace_values = [];
		foreach ( $_POST as $key => $value ) {
			if( !in_array( $key, $default_inputs ) ){
				$_key 	= str_replace( '_', ' ', $key );
				$_key 	= str_replace( '-', ' ', $_key );
				$_key 	= ucwords( $_key );
				$_value = sanitize_text_field( $value );
				$target_string[] 	= "%%{$key}%%";
				$replace_values[]	= $_value;
				$table_row .= "<tr><th>{$_key}</th><td>{$_value}</td></tr>";
			}
		}


		if ( isset( $_POST['afp_product_id'] ) ) {
			$product_id 	= (int)sanitize_text_field( $_POST['afp_product_id'] );
			$product_title 	= get_the_title( $product_id );
			$product_url 	= get_the_permalink( $product_id );
			$table_row 	   .= "<tr><th>". __( 'Product ID', 'codesigner-pro' ) ."</th><td>{$product_id}</td></tr>";
			$table_row 	   .= "<tr><th>". __( 'Product Name', 'codesigner-pro' ) ."</th><td>{$product_title}</td></tr>";
			$table_row 	   .= "<tr><th>". __( 'Product Url', 'codesigner-pro' ) ."</th><td>{$product_url}</td></tr>";
		}

		$admin_mail = get_bloginfo( 'admin_email' );
		$_subject 	= sanitize_text_field( $_POST['afp_admin_mail_subject'] );
		$subject 	= str_replace( $target_string, $replace_values, $_subject );
		$message 	= "<table>{$table_row}</table>";
		$wc_email 	= new \WC_Emails;
		$_message 	= stripslashes( $message );
		ob_start();
		$wc_email->email_header( $subject );
		echo $_message;
		$wc_email->email_footer();
		$message 	= ob_get_clean();
		$wc_email->send( $admin_mail, $subject, $message );

		if ( isset( $_POST['afp_mail_body'] ) && isset( $_POST['afp_mail_subject'] ) && isset( $_POST['afp_mail_name'] ) ) {
			$subject 		= sanitize_text_field( $_POST['afp_mail_subject'] );
			$subject 		= str_replace( $target_string, $replace_values, $subject );
			$message 		= sanitize_text_field( $_POST['afp_mail_body'] );
			$message 		= str_replace( $target_string, $replace_values, $message );;
			$_message 		= stripslashes( $message );
			$customer_mail 	= sanitize_email( $_POST[ $_POST['afp_mail_name'] ] );

			ob_start();
			$wc_email->email_header( $subject );
			echo $_message;
			$wc_email->email_footer();
			$message 	= ob_get_clean();
			$wc_email->send( $customer_mail, $subject, $message );
		}

		if ( isset( $_POST['afp_resp_redirect'] ) ) {
			$redirect_data 			= json_decode( stripslashes( sanitize_text_field( $_POST['afp_resp_redirect'] ) ) );
			$response['redirect'] 	= $redirect_data;
		}

		if ( isset( $_POST['afp_rep_msg'] ) ) {
			$res_msg 				= sanitize_text_field( $_POST['afp_rep_msg'] );
			$res_msg 				= str_replace( $target_string, $replace_values, $res_msg );
			$response['res_msg'] 	= $res_msg;
		}

		$response['status'] = 1;
		$response['message'] = __( 'Form submitted', 'codesigner-pro' );
		wp_send_json( $response );
	}

	public function add_to_compare() {
		$response = [
			 'status'	=> 0,
			 'message'	=>__( 'Unauthorized!', 'codesigner' )
		];

		global $codesigner;
		if( !wp_verify_nonce( $_POST['_wpnonce'], $this->slug ) ) {
			wp_send_json( $response );
		}

		if( !isset( $_POST['product_id'] ) ) {
			$response['message'] = __( 'No product selected!', 'codesigner' );
		    wp_send_json( $response );
		}

		$product_id = codesigner_sanitize_number( $_POST['product_id'] );
		wcd_add_to_compare( $product_id );

		$response['status'] 	= 1;
		$response['btn_text'] 	= __( 'View Table', 'codesigner' );
		$response['message'] 	= __( 'Product Added', 'codesigner' );

		wp_send_json( $response );
	}
	
	public function remove_from_compare() {
		$response = [
			'status'	=> 0,
			'message'	=>__( 'Unauthorized!', 'codesigner' )
		];

		global $codesigner;

		if( !wp_verify_nonce( $_POST['_wpnonce'], $this->slug ) ) {
		    wp_send_json( $response );
		}

		if( !isset( $_POST['product_id'] ) ) {
			$response['message'] = __( 'No product selected!', 'codesigner' );
		    wp_send_json( $response );
		}

		$compare_key 	= wcd_compare_cookie_key();
		if ( isset( $_COOKIE[ $compare_key ] ) && is_serialized( $_COOKIE[ $compare_key ] ) ) {
		    $_products 		= unserialize( sanitize_text_field( $_COOKIE[ $compare_key ] ) );
		    $products		= is_array( $_products ) ? $_products : [];
		    $products		= array_unique( $products );
			$product_id 	= codesigner_sanitize_number( $_POST['product_id'] );
			$_key 			= array_search($product_id, $products);

			if( isset( $products[ $_key ] ) ) {
				unset( $products[ $_key ] );
			}
			if ( count( $products ) > 0 ) {		    	
				$products 	= array_values( $products );
			}
			$compare_key 	= wcd_compare_cookie_key();
			setcookie(  $compare_key , serialize( $products ), time() + MONTH_IN_SECONDS, COOKIEPATH, COOKIE_DOMAIN );
			$response['status'] 	= 1;
			$response['product_id'] = $product_id;
			$response['products'] 	= $products;
			$response['message'] 	= __( 'Product removed', 'codesigner' );
		}

		wp_send_json( $response );
	}

	public function quick_view() {
		$response = [];

        if( !wp_verify_nonce( $_POST['_nonce'], $this->slug ) ) {
            $response['status']		= 0;
            $response['message'] 	=__( 'Unauthorized!', 'codesigner-pro' );
            wp_send_json( $response );
        }

		$product_id 	= codesigner_sanitize_number( $_POST['product_id'] );
		$template_id 	= codesigner_sanitize_number( $_POST['template_id'] );
		$html 			= Elementor::$instance->frontend->get_builder_content( $template_id );

		$response['status'] 	= 1;
		$response['html'] 		= $html;
		$response['title'] 		= get_the_title( $product_id );
		$response['message']    = __( 'Quick view', 'codesigner-pro' );
		wp_send_json( $response );
	}

	public function quick_checkout() {
		$response = [];

        if( !wp_verify_nonce( $_POST['_nonce'], $this->slug ) ) {
            $response['status']		= 0;
            $response['message'] 	= __( 'Unauthorized!', 'codesigner-pro' );
            wp_send_json( $response );
        }

		// $template_id 	= codesigner_sanitize_number( $_POST['template_id'] );
		
		$product_id 	= codesigner_sanitize_number( $_POST['product_id'] );

		WC()->cart->add_to_cart( $product_id );

		$response['status'] 	= 1;
		// $response['html'] 		= $html;
		$response['message']    = __( 'Quick Checkout', 'codesigner-pro' );
		wp_send_json( $response );
	}

	public function ajax_filter() {
		$response = [];

        if( !wp_verify_nonce( $_POST['_wpnonce'], 'codesigner-shop' ) ) {
            $response['status']		= 0;
            $response['message'] 	= __( 'Unauthorized!', 'codesigner-pro' );
            wp_send_json( $response );
        }

        $_settings 	= isset( $_POST['settings'] ) ? sanitize_text_field( $_POST['settings'] ) : '';
        $settings 	= unserialize( stripslashes( $_settings ) );

        $widget_id 	= isset( $_POST['widget_id'] ) ? sanitize_text_field( $_POST['widget_id'] ) : '';

		if ( wcd_is_pro_feature( $widget_id ) ) {
		    $html = Helper::get_template( 'template', "widgets/{$widget_id}", [ 'widget_id' => $widget_id, 'settings' => $settings ] );
		}
		else {
		    $html = \Codexpert\CoDesigner\Helper::get_template( 'template', "widgets/{$widget_id}", [ 'widget_id' => $widget_id, 'settings' => $settings ] );
		}

		$response['status'] 	= 1;
		$response['html'] 		= $html;
		$response['message']    = __( 'Filter', 'codesigner-pro' );
		wp_send_json( $response );
	}

	public function floating_cartremove_item() {
		$response = [];


		if( !wp_verify_nonce( $_POST['_wpnonce'], $this->slug ) ) {
			$response['status']		= 0;
			$response['message'] 	= __( 'Unauthorized!', 'codesigner-pro' );
			wp_send_json( $response );
		}

		global $woocommerce;
		$cart_item_key 	= $_POST['data-key'];
		$cart 			= WC()->cart;
		$cart->remove_cart_item( $cart_item_key );
		$totalamount 	= $cart->get_total();
		$cartQuantity 	= $cart->get_cart_contents_count();

		$response['status'] 	= 1;
		$response['message']    = __( 'Product Removed', 'codesigner-pro' );
		$response['total'] 		= $totalamount;
		$response['quantity']	= $cartQuantity;

		if ( $cart->is_empty() ) {
			$response['total'] 		= '';
			$response['message'] 	= __( 'Your Cart is empty', 'codesigner-pro' );
		}
		
		wp_send_json( $response );
	}

	/*
	 * Increment drecemnet item from cart fro floating cart widget
	 */
	public function floating_widget_cart_quantatity() {
		$response = [];

		if( ! wp_verify_nonce( $_POST['_wpnonce'], $this->slug ) ) {
			$response['status']		= 0;
			$response['message'] 	= __( 'Unauthorized!', 'codesigner-pro' );
			wp_send_json( $response );
		}

		global $woocommerce;
		$cart_item_key 			= sanitize_text_field( $_POST['data-key'] );
		$action_type 			= sanitize_text_field( $_POST['action-type'] );
		$cart 					= WC()->cart;
		$cart_item 				= $cart->get_cart_item( $cart_item_key );
		$quantity 				= $cart_item['quantity'];
		$single_product_price 	= '0';
		$remove_product 		= false;
		
		if ( $action_type == 'increment' ) {
			if ( $quantity >= 1 ) {
				$new_quantity = $quantity + 1;
				$cart->set_quantity( $cart_item_key, $new_quantity );
	
				$product_price 			= $cart_item['data']->get_price();
				$product_total 			= $product_price * $new_quantity;
				$single_product_price 	= $product_total; 			
			}
		}
		else{
			if ( $quantity > 1 ) {
				$new_quantity = $quantity - 1;
				$cart->set_quantity( $cart_item_key, $new_quantity );
	
				$product_price 			= $cart_item['data']->get_price();
				$product_total 			= $product_price * $new_quantity;
				$single_product_price 	= $product_total; 			
			}
			else {
				$cart->remove_cart_item( $cart_item_key );
				$remove_product = true;
			}
		}

		
		$total_amount 				= $cart->get_total();
		$cart_quantity 				= $cart->get_cart_contents_count();
		$response['status'] 		= 1;
		$response['message']    	= __( 'Product Added', 'codesigner-pro' );
		$response['total'] 			= $total_amount;
		$response['quantity']		= $cart_quantity;
		$response['single_price']	= $single_product_price;
		$response['single_quantity']= $new_quantity;
		$response['remove_product']	= $remove_product;

		if ( $cart->is_empty() ) {
			$response['total'] 		= '';
			$response['message'] 	= __( 'Your Cart is empty', 'codesigner-pro' );
		}
		wp_send_json( $response );
	}

	public function floating_cart_apply_coupon() {
		$response = [];

		if( ! wp_verify_nonce( $_POST['_wpnonce'], $this->slug ) ) {
			$response['status']		= 0;
			$response['message'] 	= __( 'Unauthorized!', 'codesigner-pro' );
			wp_send_json( $response );
		}
		global $woocommerce;
		$coupon_code 			= sanitize_text_field( $_POST['coupon-code'] );
		$cart 					= WC()->cart;

		if ( $cart->apply_coupon( $coupon_code ) ) {
			$cart->calculate_totals();
			$totalamount 				= $cart->get_total();
			$response['status'] 		= 1;
			$response['message']    	= __( 'Coupon applied successfully', 'codesigner-pro' );
			$response['total'] 			= $totalamount;
		}
		else {
			$totalamount 				= $cart->get_total();
			$response['status'] 		= 1;
			$response['message']    	= __( 'Coupon not applied', 'codesigner-pro' );
			$response['total'] 			= $totalamount;
		}
		wp_send_json( $response );
	}

}